# -*- coding: utf-8 -*-
"""
Created on Wed Oct 07 13:11:55 2015

"""

import matplotlib.pylab as plt
import pickle
import scipy
import pylab

class COutputModule:

    def __init__(self):
        self = self

    def PrintAnalysisToConsole(self):
        self.Analysis.PrintToConsole()
        
    
    #main module calls THIS function!!!!
    def PlotConcentrationsVersusTime(self):
        time_values = self.Analysis.Domain.Time.InclusiveRange()
        x_index = 50 # for now
        y_index = self.Analysis.Domain.Y.MidIndex()
        

        #Here the output module calls the function defined in the MODEL class
        self.Analysis.Models.AdvectionOnly.PlotConcentrationsVersusTime(time_values,x_index,y_index,'Advection Only',':')
        self.Analysis.Models.ADELongitudinal.PlotConcentrationsVersusTime(time_values,x_index,y_index,'ADE Longitudinal','--')
        self.Analysis.Models.ADETransverse.PlotConcentrationsVersusTime(time_values,x_index,y_index,'ADE Transverse','-.')
        self.Analysis.Models.ADZ.PlotConcentrationsVersusTime(time_values,x_index,y_index,'ADZ','-')
        
        #plt.ylim(-0.2,)
        #plt.xlim(-5,100)
        plt.title('Concentration %1.0f m downstream of release Coachella River' % x_index)
        plt.legend(loc=1)
        plt.xlabel('time (s)')
        plt.ylabel('Concentration (Kg/m3)')
        plt.show()
        
        
    def PlotPeakConcentrationsVersusTime(self):
        time_values = self.Analysis.Domain.Time.InclusiveRange()
        y_index = self.Analysis.Domain.Y.MidIndex()              

        self.Analysis.Models.AdvectionOnly.PlotPeakConcentrationsVersusTime(time_values,y_index,'Advection Only',':')
        self.Analysis.Models.ADELongitudinal.PlotPeakConcentrationsVersusTime(time_values,y_index,'ADE Longitudinal','--')
        self.Analysis.Models.ADETransverse.PlotPeakConcentrationsVersusTime(time_values,y_index,'ADE Transverse','-.')
        self.Analysis.Models.ADZ.PlotPeakConcentrationsVersusTime(time_values,y_index,'ADZ','-')
        
        #plt.ylim(-0.2,)
        #plt.xlim(-5,100)
        plt.legend(loc=1)
        plt.xlabel('time (s)')
        plt.ylabel('Concentration (Kg/m3)')
        plt.title('Peak concentrations vs time')
        plt.show()        
        
    def PlotPeakConcentrationsVersusDistance(self):
        distance_values = self.Analysis.Domain.X.InclusiveRange()
        y_index = self.Analysis.Domain.Y.MidIndex()              

        self.Analysis.Models.AdvectionOnly.PlotPeakConcentrationsVersusDistance(distance_values,y_index,'Advection Only',':')
        self.Analysis.Models.ADELongitudinal.PlotPeakConcentrationsVersusDistance(distance_values,y_index,'ADE Longitudinal','--')
        self.Analysis.Models.ADETransverse.PlotPeakConcentrationsVersusDistance(distance_values,y_index,'ADE Transverse','-.')
        self.Analysis.Models.ADZ.PlotPeakConcentrationsVersusDistance(distance_values,y_index,'ADZ','-')
        
        #plt.ylim(-0.2,)
        #plt.xlim(-5,100)
        plt.legend(loc=1)
        plt.xlabel('Distance (m)')
        plt.ylabel('Concentration (Kg/m3)')
        plt.title('Peak concentrations vs distance')
        plt.show()

    def PlotPeakConcentrationsNormalisedVersusTime(self):
        time_values = self.Analysis.Domain.Time.InclusiveRange()
        y_index = self.Analysis.Domain.Y.MidIndex()
        peclet_number = self.Analysis.NormalizationFactor()
        time_values_normalised = time_values * peclet_number              

        self.Analysis.Models.AdvectionOnly.PlotPeakConcentrationsNormalisedVersusTime(time_values_normalised,y_index,'Advection Only',':')
        self.Analysis.Models.ADELongitudinal.PlotPeakConcentrationsNormalisedVersusTime(time_values_normalised,y_index,'ADE Longitudinal','--')
        self.Analysis.Models.ADETransverse.PlotPeakConcentrationsNormalisedVersusTime(time_values_normalised,y_index,'ADE Transverse','-.')
        self.Analysis.Models.ADZ.PlotPeakConcentrationsNormalisedVersusTime(time_values_normalised,y_index,'ADZ','-')
        
        plt.ylim(0,1.1)
        #plt.xlim(-5,100)
        plt.legend(loc=1)
        plt.xlabel('1/Pe (-)')
        plt.ylabel('Normalised Concentration (-)')
        plt.title('Peak Normalised concentrations vs time')
        plt.show()
        
    def SetAnalysis(self, AAnalysis):
        self.Analysis = AAnalysis
    
    def SaveObject(self, AObject, AFilepath):
        with open(AFilepath, 'wb') as output:
            pickle.dump(AObject, output, pickle.HIGHEST_PROTOCOL)        
 
    def PlotPeakConcentrationsVersusTimeResiduals(self):
        time_values = self.Analysis.Domain.Time.InclusiveRange()
        
        self.Analysis.Models.PlotPeakResiduals(self.Analysis.Models.AdvectionOnly, time_values, 'Advection Only',':')
        self.Analysis.Models.PlotPeakResiduals(self.Analysis.Models.ADELongitudinal,time_values,'ADE Longitudinal','--')
        self.Analysis.Models.PlotPeakResiduals(self.Analysis.Models.ADETransverse,time_values,'ADE Transverse','-.')
        self.Analysis.Models.PlotPeakResiduals(self.Analysis.Models.ADZ,time_values,'ADZ','-')


    def PlotPeakConcentrationResiduals(self,AResiduals,AXValues,ATitle,AXLabel):
        colours = ["b","r","g"]
        markers = ["v","o","*"]
        assert len(AResiduals)==len(colours)

        for index in range(0,len(AResiduals)):
            plt.scatter(AXValues,AResiduals[index], color=colours[index], marker=markers[index])
        
        plt.xlabel(AXLabel)
        plt.ylabel('average residual')
        plt.title(ATitle)            
        plt.show

    def PlotNormalisedPeakConcentrationsVersusTimeResiduals(self):
        time_values = self.Analysis.Domain.Time.InclusiveRange()
        peclet_number = self.Analysis.NormalizationFactor()
        time_values_normalised = time_values * peclet_number
        
        self.Analysis.Models.PlotNormalisedPeakResiduals(self.Analysis.Models.AdvectionOnly, time_values_normalised, 'Advection Only',':')
        self.Analysis.Models.PlotNormalisedPeakResiduals(self.Analysis.Models.ADELongitudinal,time_values_normalised,'ADE Longitudinal','--')
        self.Analysis.Models.PlotNormalisedPeakResiduals(self.Analysis.Models.ADETransverse,time_values_normalised,'ADE Transverse','-.')
        self.Analysis.Models.PlotNormalisedPeakResiduals(self.Analysis.Models.ADZ,time_values_normalised,'ADZ','-')

        #plt.ylim(-0.2,)
        #plt.xlim(-5,100)
        plt.legend(loc=1)
        plt.xlabel('1/Pe (-)')
        plt.ylabel('Concentration (Kg/m3)')
        plt.title('Peak Normalised concentrations Residuals vs time')
        plt.show()
        
    def PrintAverageResiduals(self):
        print( 'Advection_only Average Residual: %5.2f' % self.Analysis.Models.PeakNormalisedConcentrationsOverTimeResidualsAverage(self.Analysis.Models.AdvectionOnly))
        print( 'ADE_1D Average Residual: %5.2f' % self.Analysis.Models.PeakNormalisedConcentrationsOverTimeResidualsAverage(self.Analysis.Models.ADELongitudinal))
        print( 'ADE_2D Average Residual: %5.2f' % self.Analysis.Models.PeakNormalisedConcentrationsOverTimeResidualsAverage(self.Analysis.Models.ADETransverse))
        print( 'ADZ Average Residual: %5.2f' % self.Analysis.Models.PeakNormalisedConcentrationsOverTimeResidualsAverage(self.Analysis.Models.ADZ))
    
    def CalculateExceedances(self):
        exc_adv = self.Analysis.Models.AdvectionOnly.CalculateExceedances(2.0)
        exc_ADE_1D = self.Analysis.Models.ADELongitudinal.CalculateExceedances(2.0)
        exc_ADE_2D = self.Analysis.Models.ADETransverse.CalculateExceedances(2.0)
        exc_ADZ = self.Analysis.Models.ADZ.CalculateExceedances(2.0)
        exceedances = [exc_adv,exc_ADE_1D,exc_ADE_2D,exc_ADZ]
        
        #Plot the exceedances count
        x = scipy.arange(4)
        y = exceedances
        f = pylab.figure()
        #pylab.ylabel('number of exceedances')
        #pylab.title('Exceedances Counts per model')
        
        ax = f.add_axes([0.1, 0.1, 0.8, 0.8])
        ax.bar(x, y, align='center')
        ax.set_xticks(x)
        ax.set_xticklabels(['AdvectionOnly','ADE 1D','ADE 2D','ADZ' ])
        f.show() 
